/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.world;

import ivorius.ivtoolkit.blocks.IvTileEntityHelper;
import ivorius.ivtoolkit.tools.IvWorldData;
import ivorius.ivtoolkit.world.WorldCache;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Biomes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface MockWorld
extends IBlockAccess {
    public static Real of(World world) {
        return new Real(world);
    }

    public World asWorld();

    public boolean setBlockState(@Nonnull BlockPos var1, @Nonnull IBlockState var2, int var3);

    @Nonnull
    public IBlockState func_180495_p(@Nonnull BlockPos var1);

    @Nullable
    public TileEntity func_175625_s(@Nonnull BlockPos var1);

    public void setTileEntity(@Nonnull BlockPos var1, @Nullable TileEntity var2);

    public List<Entity> getEntities(AxisAlignedBB var1, @Nullable Predicate<? super Entity> var2);

    public boolean addEntity(Entity var1);

    public boolean removeEntity(Entity var1);

    public Random rand();

    default public boolean setBlockState(BlockPos coord, IBlockState block) {
        return this.setBlockState(coord, block, 3);
    }

    @SideOnly(value=Side.CLIENT)
    default public int func_175626_b(BlockPos pos, int lightValue) {
        return 0;
    }

    default public boolean func_175623_d(BlockPos pos) {
        IBlockState state = this.func_180495_p(pos);
        return state.func_177230_c().isAir(state, (IBlockAccess)this, pos);
    }

    @SideOnly(value=Side.CLIENT)
    default public Biome func_180494_b(BlockPos pos) {
        return Biomes.field_180279_ad;
    }

    default public int func_175627_a(BlockPos pos, EnumFacing direction) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    default public WorldType func_175624_G() {
        return WorldType.field_180271_f;
    }

    default public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
        return this.func_180495_p(pos).isSideSolid((IBlockAccess)this, pos, side);
    }

    public static class VirtualWorldException
    extends RuntimeException {
    }

    public static class WorldData
    implements MockWorld {
        public IvWorldData worldData;
        public Random random = new Random();

        public WorldData(IvWorldData worldData) {
            this.worldData = worldData;
        }

        public static boolean isAt(@Nonnull BlockPos pos, NBTTagCompound nbt) {
            return pos.func_177958_n() == nbt.func_74762_e("x") && pos.func_177956_o() == nbt.func_74762_e("y") && pos.func_177952_p() == nbt.func_74762_e("z");
        }

        @Override
        public World asWorld() {
            throw new VirtualWorldException();
        }

        @Override
        public boolean setBlockState(@Nonnull BlockPos pos, @Nonnull IBlockState state, int flags) {
            this.worldData.blockCollection.setBlockState(pos, state);
            return true;
        }

        @Override
        @Nonnull
        public IBlockState func_180495_p(@Nonnull BlockPos pos) {
            return this.worldData.blockCollection.getBlockState(pos);
        }

        @Override
        public TileEntity func_175625_s(@Nonnull BlockPos pos) {
            for (NBTTagCompound nbt : this.worldData.tileEntities) {
                if (!WorldData.isAt(pos, nbt)) continue;
                return TileEntity.func_190200_a((World)IvTileEntityHelper.getAnyWorld(), (NBTTagCompound)nbt);
            }
            return null;
        }

        @Override
        public void setTileEntity(@Nonnull BlockPos pos, TileEntity tileEntity) {
            this.worldData.tileEntities.removeIf(nbt -> WorldData.isAt(pos, nbt));
            this.worldData.tileEntities.add(tileEntity.func_189515_b(new NBTTagCompound()));
        }

        @Override
        public List<Entity> getEntities(AxisAlignedBB bounds, @Nullable Predicate<? super Entity> predicate) {
            return this.worldData.entities.stream().filter(nbt -> {
                NBTTagList pos = nbt.func_150295_c("Pos", 6);
                return bounds.func_72318_a(new Vec3d(pos.func_150309_d(0), pos.func_150309_d(1), pos.func_150309_d(2)));
            }).map(nbt -> EntityList.func_75615_a((NBTTagCompound)nbt, (World)IvTileEntityHelper.getAnyWorld())).filter(predicate).collect(Collectors.toList());
        }

        @Override
        public boolean addEntity(Entity entity) {
            this.removeEntity(entity);
            return this.worldData.entities.add(entity.func_189511_e(new NBTTagCompound()));
        }

        @Override
        public boolean removeEntity(Entity entity) {
            return this.worldData.entities.removeIf(nbt -> entity.func_110124_au().equals(nbt.func_186857_a("UUID")));
        }

        @Override
        public Random rand() {
            return this.random;
        }
    }

    public static class Cache
    extends Real {
        public WorldCache cache;

        public Cache(WorldCache cache) {
            super(cache.world);
            this.cache = cache;
        }

        @Override
        public boolean setBlockState(@Nonnull BlockPos pos, @Nonnull IBlockState state, int flags) {
            return this.cache.setBlockState(pos, state, flags);
        }

        @Override
        @Nonnull
        public IBlockState func_180495_p(@Nonnull BlockPos pos) {
            return this.cache.getBlockState(pos);
        }
    }

    public static class Real
    implements MockWorld {
        public World world;

        public Real(World world) {
            this.world = world;
        }

        @Override
        public World asWorld() {
            return this.world;
        }

        @Override
        public boolean setBlockState(@Nonnull BlockPos pos, @Nonnull IBlockState state, int flags) {
            return this.world.func_180501_a(pos, state, flags);
        }

        @Override
        @Nonnull
        public IBlockState func_180495_p(@Nonnull BlockPos pos) {
            return this.world.func_180495_p(pos);
        }

        @Override
        public TileEntity func_175625_s(@Nonnull BlockPos pos) {
            return this.world.func_175625_s(pos);
        }

        @Override
        public void setTileEntity(@Nonnull BlockPos pos, TileEntity tileEntity) {
            this.world.func_175690_a(pos, tileEntity);
        }

        @Override
        public List<Entity> getEntities(AxisAlignedBB bounds, @Nullable Predicate<? super Entity> predicate) {
            return this.world.func_175674_a(null, bounds, predicate != null ? predicate::test : null);
        }

        @Override
        public boolean addEntity(Entity entity) {
            return this.world.func_72838_d(entity);
        }

        @Override
        public boolean removeEntity(Entity entity) {
            this.world.func_72900_e(entity);
            return true;
        }

        @Override
        public Random rand() {
            return this.world.field_73012_v;
        }

        @Override
        public int func_175626_b(BlockPos pos, int lightValue) {
            return this.world.func_175626_b(pos, lightValue);
        }

        @Override
        public Biome func_180494_b(BlockPos pos) {
            return this.world.func_180494_b(pos);
        }

        @Override
        public int func_175627_a(BlockPos pos, EnumFacing direction) {
            return this.world.func_175627_a(pos, direction);
        }

        @Override
        public WorldType func_175624_G() {
            return this.world.func_175624_G();
        }
    }
}

